import 'dart:convert';
import 'dart:io';
import 'package:http/http.dart' as http;
import 'package:http_parser/http_parser.dart';
import 'package:shared_preferences/shared_preferences.dart';
import '../models/user_model.dart';
import 'api_constants.dart';
import 'package:mime/mime.dart';

class UserService {
  static Future<User?> getUser() async {
    print('service');
    final token = await getToken();
    final userId = await getUserId();

    final response = await http.get(
      Uri.parse("${ApiConstants.baseUrl}/user/$userId"),
      headers: {
        "Content-Type": "application/json",
        "Authorization": "Bearer $token",
      },
    );

    if (response.statusCode == 200) {
      final Map<String, dynamic> data = jsonDecode(response.body);
      return User.fromJson(data); // <-- هنا نحول الـ Map إلى User
    } else {
      throw Exception('Failed to load user: ${response.body}');
    }
  }

  static Future<bool> updateUser(User user) async {
    final token = await getToken();
    print('user');
    print(user);
    final response = await http.put(
      Uri.parse(ApiConstants.baseUrl + '/user/${user.id}'),
      headers: {
        "Content-Type": "application/json",
        "Authorization": "Bearer $token",
      },
      body: jsonEncode(user.toJson()),
    );

    return response.statusCode == 200;
  }

  static Future<bool> uploadProfileImage(int userId, File imageFile) async {
    final uri = Uri.parse("${ApiConstants.baseUrl}/user/upload/$userId");
    var request = http.MultipartRequest('POST', uri);

    String mimeType = lookupMimeType(imageFile.path) ?? 'image/jpeg';
    var type = mimeType.split('/');

    request.files.add(
      await http.MultipartFile.fromPath(
        'profileImageUrl',
        imageFile.path,
        contentType: MediaType(type[0], type[1]),
      ),
    );

    final streamedResponse = await request.send();
    final response = await http.Response.fromStream(streamedResponse);

    if (response.statusCode == 200) {
      return true;
    } else {
      print("Upload failed: ${response.statusCode}, ${response.body}");
      return false;
    }
  }
  static Future<bool> resetPassword(String email, String newPassword) async {
    final url = Uri.parse('${ApiConstants.baseUrl}/user/reset-password');
    final token = await getToken();
    print('user');
    print(token);
    final response = await http.post(
      url,
      headers: {
        "Content-Type": "application/json",
        "Authorization": "Bearer $token",
      },
      body: jsonEncode({
        "email": email,
        "password": newPassword,
      }),
    );

    if (response.statusCode == 200) {
      return true;
    } else {
      print('Failed to reset password: ${response.body}');
      return false;
    }
  }
  static Future<bool> updateUserBio(int userId, String bio) async {
    final token = await getToken();
    final url = Uri.parse('${ApiConstants.baseUrl}/user/update-bio/$userId');

    try {
      final response = await http.put(
        url,
        headers: {
          "Content-Type": "application/json",
          "Authorization": "Bearer $token",
        },
        body: jsonEncode({"bio": bio}),
      );

      if (response.statusCode == 200) {
        return true;
      } else {
        print('Failed to update bio: ${response.statusCode}, ${response.body}');
        return false;
      }
    } catch (e) {
      print('Error updating bio: $e');
      return false;
    }
  }

}



Future<String?> getToken() async {
  final prefs = await SharedPreferences.getInstance();
  return prefs.getString('auth_token');
}

Future<int?> getUserId() async {
  final prefs = await SharedPreferences.getInstance();
  return prefs.getInt('user_id');
}
Future<void> saveToken(String token, int userId) async {
  final prefs = await SharedPreferences.getInstance();
  await prefs.setString('auth_token', token);
  await prefs.setInt('user_id', userId);
}
