import 'dart:convert';
import 'package:http/http.dart' as http;
import '../models/on_boarding_model.dart';
import './api_constants.dart';

class OnboardingService {
  final String baseUrl = ApiConstants.baseUrl;

  Future<OnboardingModel> fetchOnboarding() async {
    try {
      final response = await http.get(Uri.parse("$baseUrl/landing-images"));

      if (response.statusCode != 200) {
        throw Exception("Failed to load onboarding: ${response.statusCode}");
      }

      final data = json.decode(response.body);
      print(data);

      // إذا البيانات List وخانة واحدة على الأقل
      if (data is List && data.isNotEmpty) {
        return OnboardingModel.fromJson(data[0]);
      }

      // إذا البيانات Map مباشرة
      if (data is Map<String, dynamic>) {
        return OnboardingModel.fromJson(data);
      }

      throw Exception("Invalid onboarding data format");
    } catch (e) {
      throw Exception("Error fetching onboarding: $e");
    }
  }

}
