import 'dart:convert';
import 'package:http/http.dart' as http;
import '../models/news_model.dart';
import 'api_constants.dart'; // فيه BASE_URL

class UpdatesService {
  static Future<List<Map<String, dynamic>>> getAnnouncements() async {
    final response = await http.get(Uri.parse(ApiConstants.baseUrl+"/announcement"));
    if (response.statusCode == 200) {
      return List<Map<String, dynamic>>.from(json.decode(response.body));
    } else {
      throw Exception("Failed to load announcements");
    }
  }

  static Future<List<Map<String, dynamic>>> getNews() async {
    final response = await http.get(Uri.parse(ApiConstants.baseUrl+"/news"));
    if (response.statusCode == 200) {
      return List<Map<String, dynamic>>.from(json.decode(response.body));
    } else {
      throw Exception("Failed to load news");
    }
  }
}

