import 'dart:convert';
import 'package:http/http.dart' as http;

import 'api_constants.dart';

class LiveStreamService {

  Future<Map<String, dynamic>> getStreams() async {
    final response = await http.get(Uri.parse(ApiConstants.baseUrl+'/live-stream'));

    if (response.statusCode == 200) {
      return jsonDecode(response.body);
    } else {
      throw Exception("Failed to load streams");
    }
  }
    static Future<List<Map<String, dynamic>>> getPastMatches() async {
    final url = Uri.parse("${ApiConstants.baseUrl}/live-stream/past");
    final response = await http.get(url);

    if (response.statusCode == 200) {
      List data = json.decode(response.body);
      return data.map((e) => e as Map<String, dynamic>).toList();
    } else {
      throw Exception("Failed to load matches");
    }
  }

}
