import 'dart:convert';
import 'package:hockey_app/services/api_constants.dart';
import 'package:http/http.dart' as http;

class HomeService {
  static const String baseUrl = ApiConstants.baseUrl;

  static Future<List<dynamic>> getAllHomePages() async {
    final url = Uri.parse(ApiConstants.baseUrl+"/home/home_page");
    final response = await http.get(url);

    if (response.statusCode == 200) {
      final body = jsonDecode(response.body);
      return body;
    } else {
      throw Exception("Failed to load home pages");
    }
  }

  static Future<Map<String, dynamic>?> getHomePageById(int id) async {
    final response = await http.get(Uri.parse("$baseUrl+'/home/$id"));

    if (response.statusCode == 200) {
      final body = jsonDecode(response.body);
      return body["data"];
    } else if (response.statusCode == 404) {
      return null; // Not found
    } else {
      throw Exception("Failed to load home page with id $id");
    }
  }

}
