import 'dart:convert';
import 'package:http/http.dart' as http;
import 'api_constants.dart';
import '../models/exercise_model.dart';

class ExerciseService {
  static Future<List<Exercise>> getExercises() async {
    final response = await http.get(
      Uri.parse("${ApiConstants.baseUrl}/exercise"),
      headers: {"Content-Type": "application/json"},
    );
    if (response.statusCode == 200) {
      final List<dynamic> data = jsonDecode(response.body);
      print(data);
      return data.map((e) => Exercise.fromJson(e)).toList();
    } else {
      throw Exception('Failed to load exercises');
    }
  }

  static Future<Map<String, dynamic>> addExercise(Map<String, dynamic> data, String token) async {
    final response = await http.post(
      Uri.parse("${ApiConstants.baseUrl}/exercise"),
      headers: {
        "Content-Type": "application/json",
        "Authorization": "Bearer $token"
      },
      body: jsonEncode(data),
    );
    return jsonDecode(response.body);
  }
}
