import 'dart:convert';
import 'package:http/http.dart' as http;
import 'api_constants.dart';
import '../models/category_model.dart';

class CategoryService {
  static Future<List<Category>> getCategory() async {
    final response = await http.get(
      Uri.parse("${ApiConstants.baseUrl}/category"),
      headers: {"Content-Type": "application/json"},
    );
    if (response.statusCode == 200) {
      final List<dynamic> data = jsonDecode(response.body);
      return data.map((e) => Category.fromJson(e)).toList();
    } else {
      throw Exception('Failed to load categories');
    }
  }
}
