import 'dart:convert';
import 'package:http/http.dart' as http;
import 'api_constants.dart';
import 'package:shared_preferences/shared_preferences.dart';
import '../models/user_model.dart';

class AuthService {
  static Future<Map<String, dynamic>> login(
      String email, String password) async {
    final response = await http.post(
      Uri.parse("${ApiConstants.baseUrl}/user/login"),
      headers: {"Content-Type": "application/json"},
      body: jsonEncode({"email": email, "password": password}),
    );
    return jsonDecode(response.body);
  }

  static Future<Map<String, dynamic>> signup(Map<String, dynamic> data) async {
    final response = await http.post(
      Uri.parse("${ApiConstants.baseUrl}/user/signup"),
      headers: {"Content-Type": "application/json"},
      body: jsonEncode(data),
    );

    print("Server response body: ${response.body}");
    print("Server status code: ${response.statusCode}");

    final resBody = jsonDecode(response.body);

    if (response.statusCode >= 400) {
      throw Exception(resBody["error"] ?? "Unknown server error");
    }

    return resBody;
  }


  static Future<Map<String, dynamic>> forgotPassword(String email) async {
    final response = await http.post(
      Uri.parse("${ApiConstants.baseUrl}/users/forgot-password"),
      headers: {"Content-Type": "application/json"},
      body: jsonEncode({"email": email}),
    );
    return jsonDecode(response.body);
  }

  static Future<Map<String, dynamic>> resetPassword(
      String token, String newPassword) async {
    final response = await http.post(
      Uri.parse("${ApiConstants.baseUrl}/users/reset-password"),
      headers: {"Content-Type": "application/json"},
      body: jsonEncode({"token": token, "newPassword": newPassword}),
    );
    return jsonDecode(response.body);
  }

  static Future<bool> checkUserActive(String token) async {
    final response = await http.get(
      Uri.parse(ApiConstants.baseUrl + "/user/status"),
      headers: {
        "Authorization": "Bearer $token",
      },
    );

    if (response.statusCode == 200) {
      final data = jsonDecode(response.body);
      return data["isActive"] ?? false;
    } else {
      return false;
    }
  }
}

Future<void> saveUserSession(String token, int id) async {
  final prefs = await SharedPreferences.getInstance();
  await prefs.setString("auth_token", token);
  await prefs.setInt('user_id', id);
}

Future<void> logout() async {
  final prefs = await SharedPreferences.getInstance();
  await prefs.remove("auth_token");
  await prefs.remove("user_id");
}
