import 'dart:convert';
import 'package:http/http.dart' as http;
import 'api_constants.dart';

class AboutUsService {
  static Future<Map<String, dynamic>> getAboutUs() async {
    final url = Uri.parse('${ApiConstants.baseUrl}/home/about-us');
    final response = await http.get(url);

    if (response.statusCode == 200) {
      final data = json.decode(response.body);
      if (data is Map<String, dynamic>) {
        return data;
      } else {
        throw Exception("Unexpected response format");
      }
    } else {
      throw Exception("Failed to load About Us");
    }
  }
}

