import 'package:flutter/material.dart';
import '../l10n/app_localizations.dart';
import '../theme/app_colors.dart';
import 'uniform_part_detail_screen.dart';

class UniformScreen extends StatefulWidget {
  const UniformScreen({super.key});

  @override
  State<UniformScreen> createState() => _UniformScreenState();
}

class _UniformScreenState extends State<UniformScreen>
    with SingleTickerProviderStateMixin {
  late TabController _tabController;

  @override
  void initState() {
    _tabController = TabController(length: 2, vsync: this);
    super.initState();
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final t = AppLocalizations.of(context)!;
    return Scaffold(
      backgroundColor: Theme.of(context).scaffoldBackgroundColor,
      body: SafeArea(
        child: Container(
          color: Theme.of(context).appBarTheme.backgroundColor,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              const SizedBox(height: 12),
              Container(
                padding: const EdgeInsets.symmetric(horizontal: 18),
                color: Theme.of(context).appBarTheme.backgroundColor,
                child: TabBar(
                  controller: _tabController,
                  indicatorColor: const Color(0xFF7EC6B1),
                  labelColor: Theme.of(context).textTheme.titleLarge!.color,
                  unselectedLabelColor: Colors.grey,
                  labelStyle: const TextStyle(
                      fontWeight: FontWeight.bold, fontSize: 16),
                  unselectedLabelStyle:
                  const TextStyle(fontWeight: FontWeight.normal),
                  indicatorWeight: 3,
                  tabs: [
                    Tab(text: t.goalie),
                     Tab(text: t.player),
                  ],
                ),
              ),
              const SizedBox(height: 12),
              Expanded(
                child: TabBarView(
                  controller: _tabController,
                  children: [
                    _buildUniformImage(
                      context,
                      'assets/images/goalie_uniform.png',
                      0, // تاب Goalie
                    ),
                    _buildUniformImage(
                      context,
                      'assets/images/player_uniform.png',
                      1, // تاب Player
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  // دالة بناء الصورة مع عناصرها لكل تاب
  Widget _buildUniformImage(BuildContext context, String imagePath, int tabIndex) {
    final screenWidth = MediaQuery.of(context).size.width;

    // نحدد مواقع كل العناصر حسب التاب
    final positions = tabIndex == 0
        ? [ // تاب Goalie
      {'top': 0.02, 'left': 0.42, 'width': 0.25, 'height': 0.17,'id':1}, // 🧢 الطاقية
      {'top': 0.45, 'left': 0.10, 'width': 0.07, 'height': 0.40,'id':2}, // 🏒 العصا
      {'top': 0.21, 'left': 0.25, 'width': 0.5, 'height': 0.2,'id':3}, // 👕 الصدرية
      {'top': 0.43, 'left': 0.33, 'width': 0.35, 'height': 0.2,'id':4}, // 👖 البنطال
      {'top': 0.42, 'left': 0.70, 'width': 0.15, 'height': 0.14,'id':5}, // 🧤 الكف الأيمن
      {'top': 0.42, 'left': 0.18, 'width': 0.11, 'height': 0.12,'id':5}, // 🧤 الكف الأيسر
      {'top': 0.75, 'left': 0.19, 'width': 0.1, 'height': 0.07,'id':6}, // 🏒 الكرة
      {'top': 0.65, 'left': 0.3, 'width': 0.45, 'height': 0.25,'id':7}, // 👟 القدمين
    ]
        : [ // تاب Player
      {'top': 0.03, 'left': 0.35, 'width': 0.25, 'height': 0.15,'id':10}, // 🧢 الطاقية
      {'top': 0.45, 'left': 0.15, 'width': 0.09, 'height': 0.48,'id':11}, // 🏒 العصا
      {'top': 0.20, 'left': 0.25, 'width': 0.45, 'height': 0.20,'id':12}, // 👕 الصدرية
      {'top': 0.48, 'left': 0.30, 'width': 0.38, 'height': 0.19,'id':13}, // 👖 البنطال
      {'top': 0.41, 'left': 0.68, 'width': 0.10, 'height': 0.10,'id':14}, // 🧤 الكف الأيمن
      {'top': 0.79, 'left': 0.25, 'width': 0.09, 'height': 0.08,'id':15}, // 🏒 الكرة
      {'top': 0.72, 'left': 0.35, 'width': 0.32, 'height': 0.20,'id':16}, // 👟 القدمين
    ];

    return Center(
      child: ClipRRect(
        borderRadius: BorderRadius.circular(16),
        child: Container(
          width: screenWidth * 0.9,
          child: AspectRatio(
            aspectRatio: 9 / 16,
            child: LayoutBuilder(
              builder: (context, constraints) {
                final w = constraints.maxWidth;
                final h = constraints.maxHeight;

                return Stack(
                  children: [
                    Image.asset(
                      imagePath,
                      fit: BoxFit.contain,
                      width: w,
                      height: h,
                    ),
                    // كل العناصر في تكرار loop
                    for (int i = 0; i < positions.length; i++)
                      Positioned(
                        top: h * positions[i]['top']!,
                        left: w * positions[i]['left']!,
                        width: w * positions[i]['width']!,
                        height: h * positions[i]['height']!,
                        child: _partTap(context, positions[i]['id']!),
                      ),
                  ],
                );
              },
            ),
          ),
        ),
      ),
    );
  }

  Widget _partTap(BuildContext context, num id) {
    return GestureDetector(
      onTap: () {
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (_) => UniformPartDetailScreen(id: id as int),
          ),
        );
      },
      child: Container(
        color: Colors.transparent,
      ),
    );
  }
}
