import 'package:flutter/material.dart';
import '../l10n/app_localizations.dart';

class AdsDetailsPage extends StatelessWidget {
  final String titleKey; // المفتاح للترجمة
  const AdsDetailsPage({super.key, required this.titleKey});

  @override
  Widget build(BuildContext context) {
    final tr = AppLocalizations.of(context)!;

    // ترجمة العنوان باستخدام المفتاح
    String translatedTitle;
    switch (titleKey) {
      case 'ads':
        translatedTitle = tr.ads;
        break;
      case 'live':
        translatedTitle = tr.live;
        break;
      default:
        translatedTitle = titleKey;
    }

    return Scaffold(
      appBar: AppBar(title: Text(translatedTitle)),
      body: Center(child: Text("${tr.ads} details: $translatedTitle")),
    );
  }
}
