import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import '../services/about_us.dart';
import '../providers/locale_provider.dart';
import '../l10n/app_localizations.dart';

class AboutUsPage extends StatefulWidget {
  const AboutUsPage({super.key});

  @override
  State<AboutUsPage> createState() => _AboutUsPageState();
}

class _AboutUsPageState extends State<AboutUsPage> {
  String content = "";
  bool isLoading = true;

  @override
  void initState() {
    super.initState();
    _loadAboutUs();
  }

  Future<void> _loadAboutUs() async {
    try {
      final data = await AboutUsService.getAboutUs();
      // لازم يرجع Map: {"data_ar": "...", "data_en": "..."}

      final locale = Provider.of<LocaleProvider>(context, listen: false).locale;
      String langCode = locale.languageCode;

      setState(() {
        if (langCode == 'ar') {
          content = data["data_ar"] ?? "";
        } else {
          content = data["data_en"] ?? "";
        }
        isLoading = false;
      });
    } catch (_) {
      setState(() {
        content = "";
        isLoading = false;
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    final tr = AppLocalizations.of(context)!;

    return Scaffold(
      appBar: AppBar(title: Text(tr.about_us)),
      body: Center(
        child: isLoading
            ? const CircularProgressIndicator()
            : Padding(
          padding: const EdgeInsets.all(16.0),
          child: Text(
            content.isNotEmpty ? content : tr.loading_error,
            textAlign: TextAlign.center,
            style: const TextStyle(fontSize: 18),
          ),
        ),
      ),
    );
  }
}
