import 'package:flutter/material.dart';
import 'dart:async';

class SplashScreen extends StatefulWidget {
  final bool isLoggedIn;
  const SplashScreen({super.key, required this.isLoggedIn});

  @override
  State<SplashScreen> createState() => _SplashScreenState();
}

class _SplashScreenState extends State<SplashScreen>
    with TickerProviderStateMixin {
  late AnimationController _controller;
  late Animation<double> _scaleAnimation;

  late AnimationController _exitController;
  late Animation<double> _exitAnimation;

  @override
  void initState() {
    super.initState();

    // حركة الدخول
    _controller = AnimationController(
      vsync: this,
      duration: const Duration(seconds: 1),
    );
    _scaleAnimation =
        CurvedAnimation(parent: _controller, curve: Curves.easeOutBack);
    _controller.forward();

    // بعد 2.5 ثانية نبدأ حركة الخروج
    Timer(const Duration(seconds: 2), () {
      _exitController.forward();
    });

    // حركة الخروج (التكبير الكبير)
    _exitController = AnimationController(
      vsync: this,
      duration: const Duration(milliseconds: 800),
    );
    _exitAnimation = Tween<double>(begin: 1.0, end: 20.0).animate(
      CurvedAnimation(parent: _exitController, curve: Curves.easeIn),
    );

    _exitController.addStatusListener((status) {
      if (status == AnimationStatus.completed) {
        // بعد ما يكبر اللوقو للآخر → ننتقل للصفحة
        if (widget.isLoggedIn) {
          Navigator.pushReplacementNamed(context, '/main');
        } else {
          Navigator.pushReplacementNamed(context, '/home');
        }
      }
    });
  }

  @override
  void dispose() {
    _controller.dispose();
    _exitController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: const Color(0xFFD8F3EC),
      body: Center(
        child: AnimatedBuilder(
          animation: _exitAnimation,
          builder: (context, child) {
            return ScaleTransition(
              scale: _scaleAnimation,
              child: Transform.scale(
                scale: _exitAnimation.value,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    Image.asset(
                      'assets/images/logo_landingpage_NoBackground.png',
                      width: 160,
                    ),
                    const SizedBox(height: 20),
                    const Text(
                      'الإتحاد السعودي للهوكي',
                      style: TextStyle(
                        color: Color(0xFF4E277B),
                        fontSize: 22,
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                    const SizedBox(height: 8),
                    const Text(
                      'Saudi Hockey Federation',
                      style: TextStyle(
                        color: Color(0xFF4E277B),
                        fontSize: 16,
                      ),
                    ),
                  ],
                ),
              ),
            );
          },
        ),
      ),
    );
  }
}
