class User {
  final int? id;
  String? nick_name;   // ممكن يكون null
  String? first_name;  // ممكن يكون null
  String? last_name;   // ممكن يكون null
  String? gender;      // ممكن يكون null
  DateTime? birthDate;
  String? email;
  String? phone;
  String? weight;      // ممكن يكون null
  String? height;      // ممكن يكون null
  String? role;
  String? profileImageUrl;
  String? bio;

  User({
     this.id,
    this.nick_name,
    this.first_name,
    this.last_name,
    this.gender,
    this.birthDate,
    this.role,
    this.email,
    this.phone,
    this.height,
    this.weight,
    this.profileImageUrl,
    this.bio
  });

  factory User.fromJson(Map<String, dynamic> json) {
    return User(
      id: json['id'],
      nick_name: json['nick_name'] ?? "",
      first_name: json['first_name'] ?? "",
      last_name: json['last_name'] ?? "",
      gender: json['gender'] ?? "",
      birthDate: json['birthDate'],
      role: json['role'] ?? "",
      weight: json['weight'] ?? "",
      height: json['height'] ?? "",
      email: json['email'] ?? "",
      phone: json['phone'] ?? "",
        profileImageUrl: json['profileImageUrl']??"",
        bio: json['bio']??""
    );
  }

  Map<String, dynamic> toJson() => {
    "id": id,
    "nick_name": nick_name ?? "",
    "first_name": first_name ?? "",
    "last_name": last_name ?? "",
    "gender": gender ?? "",
    "birthDate": birthDate ?? "",
    "role": role ?? "",
    "email": email ?? "",
    "phone": phone ?? "",
    "weight": weight ?? "",
    "height": height ?? "",
    "profileImageUrl": profileImageUrl ??"",
    "bio": bio ??""
  };
}
