class OnboardingModel {
  final int id;
  final String caption_ar;
  final String caption_en;
  final String description_ar;
  final String description_en;
  final String image1;
  final String image2;
  final String image3;
  final String? video;
  final String type; // video أو image

  OnboardingModel({
    required this.id,
    required this.caption_ar,
    required this.caption_en,
    required this.description_ar,
    required this.description_en,
    required this.image1,
    required this.image2,
    required this.image3,
    this.video,
    required this.type,
  });

  factory OnboardingModel.fromJson(Map<String, dynamic> json) {
    // نحط الصور الغير فاضية في ليست
    List<String> imgs = [];
    if (json['image1'] != null && json['image1'].toString().isNotEmpty) {
      imgs.add(json['image1']);
    }
    if (json['image2'] != null && json['image2'].toString().isNotEmpty) {
      imgs.add(json['image2']);
    }
    if (json['image3'] != null && json['image3'].toString().isNotEmpty) {
      imgs.add(json['image3']);
    }

    return OnboardingModel(
      id: int.parse(json['id'].toString()),
      caption_ar: json['caption_ar'] ?? "",
      caption_en: json['caption_en'] ?? "",
      description_ar: json['description_ar'] ?? "",
      description_en: json['description_en'] ?? "",
      image1: json['image1'] ?? "",
      image2: json['image2'] ?? "",
      image3: json['image3'] ?? "",
      video: json['video'],
      type: json['type'] ?? "image",
    );
  }
}
