class Exercise {
  final int id;
  final String title_ar;
  final String title_en;
  final String description_ar;
  final String description_en;
  final String image;
  final String? video;
  final String? level;
  final String? duration;
  final String? time;
  final int category; // نخليه String لتسهيل المقارنة

  Exercise({
    required this.id,
    required this.title_ar,
    required this.title_en,
    required this.description_ar,
    required this.description_en,
    required this.image,
    this.video,
    this.level,
    this.duration,
    this.time,
    required this.category,
  });

  factory Exercise.fromJson(Map<String, dynamic> json) {
    return Exercise(
      id: json['id'] ?? 0,
      title_ar: json['title_ar'] ?? '',
      title_en: json['title_en'] ?? '',
      description_ar: json['description_ar'] ?? '',
      description_en: json['description_en'] ?? '',
      image:json['image'],
      video: json['video'] ?? '',
      level: json['level'] ?? '',
      duration: json['duration'] ?? '',
      time: json['time'] ?? '',
      category: json['category'] is String
          ? int.parse(json['category'])
          : json['category'], // نحول int → String
    );
  }
}
