// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class AppLocalizationsAr extends AppLocalizations {
  AppLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get welcome => ' 👋 مرحبا';

  @override
  String get uniform => 'الزي';

  @override
  String get training => 'التدريبات';

  @override
  String get live => 'البث المباشر';

  @override
  String get ads => 'إعلانات';

  @override
  String get profile => 'الملف الشخصي';

  @override
  String get save => 'حفظ';

  @override
  String get nickname => 'اللقب';

  @override
  String get first_name => 'الاسم الأول';

  @override
  String get last_name => 'اسم العائلة';

  @override
  String get gender => 'الجنس';

  @override
  String get select => 'اختر';

  @override
  String get weight => 'الوزن';

  @override
  String get height => 'الطول';

  @override
  String get email => 'البريد الإلكتروني';

  @override
  String get phone_number => 'رقم الهاتف';

  @override
  String get language => 'اللغة';

  @override
  String get english => 'الإنجليزية';

  @override
  String get arabic => 'العربية';

  @override
  String get theme => 'الثيم';

  @override
  String get light => 'فاتح';

  @override
  String get dark => 'داكن';

  @override
  String get change_password => 'تغيير كلمة المرور';

  @override
  String get logout => 'تسجيل الخروج';

  @override
  String get logout_confirm => 'هل أنت متأكد من تسجيل الخروج؟';

  @override
  String get cancel => 'إلغاء';

  @override
  String get about_us => 'معلومات عنا';

  @override
  String get loading_error => 'فشل في تحميل المحتوى.';

  @override
  String get ad_details => 'تفاصيل الإعلان';

  @override
  String get exercise_list => 'قائمة التمارين';

  @override
  String get no_exercises_available => 'لا توجد تمارين متاحة';

  @override
  String get start_workout => 'ابدأ التمرين';

  @override
  String get advanced => 'متقدم';

  @override
  String get weight_unit => 'كغ';

  @override
  String get time_unit => 'دقيقة';

  @override
  String get clicked_ad => 'تم النقر على الإعلان';

  @override
  String get description_placeholder => 'لا يوجد وصف متاح';

  @override
  String get exercises => 'تمارين';

  @override
  String get all => 'الكل';

  @override
  String get error_loading_categories => 'خطأ في تحميل التصنيفات';

  @override
  String get error_loading_exercises => 'خطأ في تحميل التمارين';

  @override
  String get forgot_your_password => 'نسيت كلمة المرور';

  @override
  String get enter_email_to_reset_password => 'أدخل بريدك الإلكتروني لإعادة تعيين كلمة المرور';

  @override
  String get please_enter_your_email => 'الرجاء إدخال البريد الإلكتروني';

  @override
  String get enter_a_valid_email => 'الرجاء إدخال بريد إلكتروني صحيح';

  @override
  String get send_reset_link => 'إرسال رابط إعادة التعيين';

  @override
  String password_reset_link_sent(Object email) {
    return 'تم إرسال رابط إعادة تعيين كلمة المرور إلى $email';
  }

  @override
  String get matches => 'المباريات';

  @override
  String get live_stream => 'البث المباشر';

  @override
  String get latest_announcements => 'أحدث الإعلانات';

  @override
  String get trainings => 'التدريبات';

  @override
  String get now_live => 'يُبث الآن';

  @override
  String get upcoming_streams => 'البث القادم';

  @override
  String get previous_streams => 'البث السابق';

  @override
  String get no_live_stream => 'لا يوجد بث مباشر حاليا';

  @override
  String get next_stream_starts_in => 'يبدأ البث القادم خلال';

  @override
  String get stream_not_started => 'البث لم يبدأ بعد';

  @override
  String get watch_now => 'شاهد الآن';

  @override
  String get pastMatches => 'المباريات السابقة';

  @override
  String get vs => 'ضد';

  @override
  String get score => 'النتيجة';

  @override
  String get updates => 'التحديثات';

  @override
  String get announcements => 'الإعلانات';

  @override
  String get news => 'الأخبار';

  @override
  String get noDataAvailable => 'لا توجد بيانات';

  @override
  String get error => 'خطأ';

  @override
  String get newsContent => 'محتوى الخبر';

  @override
  String get createAccount => 'إنشاء حساب';

  @override
  String get alreadyHaveAccount => 'هل لديك حساب بالفعل؟ ';

  @override
  String get login => 'تسجيل الدخول';

  @override
  String get resetPassword => 'إعادة تعيين كلمة المرور';

  @override
  String get enterEmailAndPassword => 'أدخل بريدك الإلكتروني وكلمة المرور الجديدة';

  @override
  String get enterEmail => 'أدخل البريد الإلكتروني';

  @override
  String get enterValidEmail => 'أدخل بريدًا إلكترونيًا صالحًا';

  @override
  String get newPassword => 'كلمة المرور الجديدة';

  @override
  String get enterNewPassword => 'يرجى إدخال كلمة المرور الجديدة';

  @override
  String get passwordMin6Chars => 'يجب أن تكون كلمة المرور 6 أحرف على الأقل';

  @override
  String get confirmPassword => 'تأكيد كلمة المرور';

  @override
  String get confirmPasswordText => 'يرجى تأكيد كلمة المرور';

  @override
  String get passwordsDoNotMatch => 'كلمتا المرور غير متطابقتين';

  @override
  String get passwordResetSuccess => 'تم إعادة تعيين كلمة المرور بنجاح';

  @override
  String get passwordResetFailed => 'فشل في إعادة تعيين كلمة المرور';

  @override
  String get firstName => 'الاسم الأول';

  @override
  String get enterFirstName => 'أدخل الاسم الأول';

  @override
  String get lastName => 'اسم العائلة';

  @override
  String get enterLastName => 'أدخل اسم العائلة';

  @override
  String get emailAddress => 'البريد الإلكتروني';

  @override
  String get password => 'كلمة المرور';

  @override
  String get enterPassword => 'أدخل كلمة المرور';

  @override
  String get passwordMin8Chars => 'يجب أن تكون كلمة المرور 8 أحرف على الأقل';

  @override
  String get passwordInfo => 'اختر كلمة مرور تتكون من 8 أحرف على الأقل ويمكن أن تحتوي على أرقام ورموز خاصة.';

  @override
  String get phoneOptional => 'رقم الهاتف (اختياري)';

  @override
  String get phoneDigitsOnly => 'يجب أن يحتوي رقم الهاتف على أرقام فقط';

  @override
  String get selectRole => 'اختر الدور';

  @override
  String get selectRoleValidation => 'يرجى اختيار الدور';

  @override
  String get privacyPolicyNotice => 'بإنشاء حساب، فإنك توافق على سياسة الخصوصية وشروط الاستخدام.';

  @override
  String get next => 'التالي';

  @override
  String get signup => 'تسجيل';

  @override
  String get signupFailed => 'فشل التسجيل';

  @override
  String get saudiHockeyFederationAr => 'الاتحاد السعودي للهوكي';

  @override
  String get saudiHockeyFederationEn => 'الاتحاد السعودي للهوكي';

  @override
  String get category => 'الفئة';

  @override
  String get level => 'المستوى';

  @override
  String get duration => 'المدة';

  @override
  String get description => 'الوصف';

  @override
  String get unknown => 'غير معروف';

  @override
  String get noDescription => 'لا يوجد وصف متاح';

  @override
  String get play => 'تشغيل';

  @override
  String get pause => 'إيقاف';

  @override
  String get detailsAbout => 'تفاصيل عن';

  @override
  String get variants => 'الأنواع';

  @override
  String get close => 'إغلاق';

  @override
  String get errorLoadingData => 'خطأ في تحميل البيانات';

  @override
  String get noDataFound => 'لا توجد بيانات';

  @override
  String get goalie => 'حارس المرمى';

  @override
  String get player => 'لاعب';

  @override
  String get welcomeTitle => 'مدرب الهوكي';

  @override
  String get welcomeSubtitle => 'مهما كان هدفك، مدربنا يساعدك\nعلى الوصول له بتجربة تدريب شخصية.';

  @override
  String get welcome_back => 'مرحبا بعودتك';

  @override
  String get login_successful => 'تم تسجيل الدخول بنجاح';

  @override
  String get login_failed => 'فشل تسجيل الدخول';

  @override
  String get continue_btn => 'استمرار';

  @override
  String get ok => 'حسناً';

  @override
  String get invalid_email_or_password => 'البريد الإلكتروني أو كلمة المرور غير صحيحة';

  @override
  String get email_address => 'البريد الإلكتروني';

  @override
  String get email_hint => 'أدخل بريدك الإلكتروني';

  @override
  String get login_agreement => 'بتسجيل الدخول، فإنك توافق على سياسة الخصوصية والشروط.';

  @override
  String get forgot_password => 'نسيت كلمة المرور؟';

  @override
  String get numberUnit => 'مرات';

  @override
  String get teams => 'الفرق';

  @override
  String get date => 'البيانات';

  @override
  String get details => 'تفاصيل';

  @override
  String get home => 'الرئيسية';

  @override
  String get exercise => 'تمارين';

  @override
  String get required_field => 'مطلوب';

  @override
  String get male => 'ذكر';

  @override
  String get female => 'أنثى';

  @override
  String get birthDate => 'تاريخ الميلاد';

  @override
  String get phone => 'الهاتف';

  @override
  String get profile_updated => 'تم تعديل الملف الشخصي';

  @override
  String get emailAlreadyExists => 'خطأ الايميل موجود مسبقا';

  @override
  String get reset_password => 'إعادة تعيين كلمة المرور';

  @override
  String get enter_new_password => 'أدخل كلمة المرور الجديدة';

  @override
  String get new_password => 'كلمة المرور الجديدة';

  @override
  String get confirm_password => 'تأكيد كلمة المرور';

  @override
  String get please_enter_password => 'الرجاء إدخال كلمة المرور';

  @override
  String get password_min_6_chars => 'كلمة المرور يجب أن تحتوي على 6 أحرف على الأقل';

  @override
  String get passwords_do_not_match => 'كلمات المرور غير متطابقة';

  @override
  String get password_updated_successfully => 'تم تحديث كلمة المرور بنجاح';

  @override
  String get something_went_wrong => 'حدث خطأ ما';
}
